/**
 * Section manager class
 *
 * @module     local_remuihomepage/sectionmanager
 * @copyright  (c) 2018 WisdmLabs (https://wisdmlabs.com/)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_remuihomepage/sectionmanager",["jquery","core/ajax","core/templates","core/notification","theme_remui/notice"],(function($,Ajax,Templates,Notification,Notice){const RemUIEvents_SECTION_ADDED="theme_remui-frontpage-section-added",RemUIEvents_SECTION_UPDATED="theme_remui-frontpage-section-updated";let SECTIONSELECTOR="";var loadedSections=[],sectionDeletion=[];function SectionManager(){this.sectioncontainer="#page-site-index .home-sections",this.templateprefix="local_remuihomepage/",this.templateprefix+=$("body").hasClass("remui_lite")?"lite_":""}return SectionManager.prototype.setLoadedSection=function(id,json){loadedSections[id]=json},SectionManager.prototype.getLoadedSection=function(instanceid){return loadedSections[instanceid]},SectionManager.prototype.setSectionName=function(name){this.name=name},SectionManager.prototype.setInstanceid=function(id){this.instanceid=id,SECTIONSELECTOR='section[data-instance="'+id+'"]'},SectionManager.prototype.templateprefixer=function(str){return this.templateprefix+str},SectionManager.prototype.activateLoader=function(data){data=this.getJsonParsedData(data);let callback=function(){this.setInstanceid(data.id),this.saveSectionsOrder(),$("body").trigger("scroll"),this.scrollToSection('section[data-instance="'+data.id+'"]')}.bind(this);this.renderTemplate(this.templateprefixer(data.sectionname),data,this.sectioncontainer,callback)},SectionManager.prototype.scrollToSection=function(selector){var offset=$(selector).offset().top-65;$("html, body").animate({scrollTop:offset},1e3)},SectionManager.prototype.renderTemplate=function(template,configdata,selector,callback){Templates.render(template,configdata).then((function(html,js){Templates.appendNodeContents(selector,html,js),$("body").trigger({type:RemUIEvents_SECTION_ADDED,configdata:configdata}),null!=callback&&callback()}))},SectionManager.prototype.getSectionElement=function(instanceid){return!1!==instanceid&&this.setInstanceid(instanceid),$("body").find(SECTIONSELECTOR)},SectionManager.prototype.playSliderVideo=function(instanceid){var slider=this.getSectionElement(instanceid);slider.find(".carousel-item:not(.active) video").each((function(index,video){video.pause()})),slider.find(".carousel-item.active video").each((function(index,video){video.play()}))},SectionManager.prototype.renderTemplates=function(configdata,selector){let json=configdata.pop(),section=this.getJsonParsedData(json);this.setLoadedSection(section.id,json),section.lazyloading=!0,Templates.render("local_remuihomepage/common",section).done(function(html,js){html=$(html).height(window.innerHeight+"px"),Templates.appendNodeContents(selector,html,js),0==appearanimation&&$("body").trigger("scroll"),this.hideAllSectionsLoader(),jQuery(window).scrollTop(0),0!=configdata.length&&this.renderTemplates(configdata,selector)}.bind(this)).fail(function(ex){this.hideAllSectionsLoader(),Notification.exception(ex)}.bind(this))},SectionManager.prototype.getJsonParsedData=function(data){return JSON.parse(data)},SectionManager.prototype.addSection=function(){Ajax.call([{methodname:"local_remuihomepage_create_section_instance",args:{sectionname:this.name},done:this.activateLoader.bind(this),fail:Notification.exception}])},SectionManager.prototype.hideAllSectionsLoader=function(){$(".sections-loader-wrapper").removeClass("show"),setTimeout((function(){$(".sections-loader-wrapper").hide(),$(window).trigger("scroll")}),300)},SectionManager.prototype.showAllSectionsLoader=function(){$(".sections-loader-wrapper").addClass("show").css("display","block")},SectionManager.prototype.showSectionLoader=function(instanceid,show){$('.section-loader-wrapper[data-instance="'+instanceid+'"]').toggleClass("d-none",!show)},SectionManager.prototype.addAllSections=function(response){response.sections.reverse(),0!=response.sections.length?this.renderTemplates(response.sections,this.sectioncontainer):this.hideAllSectionsLoader()},SectionManager.prototype.LoadAllSections=function(){Ajax.call([{methodname:"local_remuihomepage_fetch_all_instances",args:{},done:this.addAllSections.bind(this),fail:function(ex){Notification.exception(ex),this.hideAllSectionsLoader()}.bind(this)}])},SectionManager.prototype.reloadSection=function(response,callback){if(0==response.success)return;let context=JSON.parse(response.context);this.setInstanceid(context.id);let reloadingSection=$(SECTIONSELECTOR);Templates.render(this.templateprefixer(context.sectionname),context).done(function(html,js){html=$(html),0==appearanimation&&$(html).removeClass("invisible"),Templates.replaceNode(reloadingSection,html,js),$("body").trigger({type:RemUIEvents_SECTION_UPDATED,configdata:context}),"slider"==context.sectionname&&this.playSliderVideo(context.id),$("body").trigger("scroll"),null!=callback&&callback()}.bind(this)).fail(function(ex){this.showSectionLoader(this.instanceid,!1),Notification.exception(ex)}.bind(this))},SectionManager.prototype.updateSection=function(instanceid,formdata){this.showSectionLoader(instanceid,!0),Ajax.call([{methodname:"local_remuihomepage_update_section_instance",args:{instanceid:instanceid,jsonformdata:formdata},done:function(response){Notice.success(M.util.get_string("sectionupdated","local_remuihomepage"),4e3),this.reloadSection(response,null)}.bind(this),fail:function(ex){this.showSectionLoader(instanceid,!1),Notification.exception(ex)}.bind(this)}])},SectionManager.prototype.deletionTimer=function(id,action){0==action&&clearInterval(sectionDeletion[id]);var section=this.getSectionElement(!1),timer=$(section).find(".cancel-delete-section .section-deletion-timer");sectionDeletion[id]=setInterval(function(){var time=parseInt($(timer).text())-1;$(timer).text(time),0==time&&(clearInterval(sectionDeletion[id]),$(section).remove(),this.saveSectionsOrder(),$("body").trigger("scroll"))}.bind(this),1e3)},SectionManager.prototype.deleteInstance=function(id,action){if(this.showSectionLoader(id,!0),this.setInstanceid(id),2==action)return this.deletionTimer(id,!1),this.getSectionElement(!1).remove(),this.saveSectionsOrder(),void $("body").trigger("scroll");1==action&&Notice.success(M.util.get_string("sectiondeleted","local_remuihomepage"),4e3),Ajax.call([{methodname:"local_remuihomepage_delete_section_instance",args:{instanceid:id,action:action},done:function(response){this.reloadSection(response,function(){this.deletionTimer(id,action)}.bind(this)),this.saveSectionsOrder()}.bind(this),fail:function(ex){this.showSectionLoader(id,!1),Notification.exception(ex)}.bind(this)}])},SectionManager.prototype.getSectionsOrder=function(){let sections=$("body").find("section[data-instance]"),order=[];return sections.each((function(index,section){$(section).find(".section-delete-overlay")&&order.push($(section).data("instance"))})),order},SectionManager.prototype.saveSectionsOrder=function(){transparentheader&&$("body").toggleClass("has-slider animate-header",$("body").find("section[data-instance]:first-child").is(".section-slider"));let order=this.getSectionsOrder();return Ajax.call([{methodname:"local_remuihomepage_save_sections_order",args:{order:order}}])[0]},SectionManager.prototype.reorderSection=function(instanceid,move,saveorder){this.setInstanceid(instanceid);let section=$(SECTIONSELECTOR);if(-1!=move||section.is(":first-child")){if(1!=move||section.is(":last-child"))return;section.next().insertBefore(section)}else section.prev().insertAfter(section);0!=saveorder&&this.saveSectionsOrder().fail(function(ex){Notification.exception(ex),this.reorderSection(instanceid,-1*move,!1)}.bind(this))},SectionManager.prototype.updateVisibility=function(instanceid,visible){var visibilityButton=this.getSectionElement(instanceid).find("button.section-visibility");Ajax.call([{methodname:"local_remuihomepage_update_section_visibility",args:{id:instanceid,visible:visible},done:function(response){$(visibilityButton).data("visible",visible),$(visibilityButton).find(".edw-icon").toggleClass("edw-icon-Show",visible),$(visibilityButton).find(".edw-icon").toggleClass("edw-icon-Hide",!visible),visible?($(visibilityButton).attr("title","Hide"),$(visibilityButton).find(".icon").attr("title","Hide")):($(visibilityButton).attr("title","Show"),$(visibilityButton).find(".icon").attr("title","Show"))}.bind(this),fail:Notification.exception}])},new SectionManager}));

//# sourceMappingURL=sectionmanager.min.js.map